/*
 * Decompiled with CFR 0.152.
 */
package org.python.constantine.platform;

import java.lang.reflect.Array;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.python.constantine.Constant;
import org.python.constantine.ConstantSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConstantResolver<E extends Enum<E>> {
    public static final String __UNKNOWN_CONSTANT__ = "__UNKNOWN_CONSTANT__";
    private final Object modLock = new Object();
    private final Class<E> enumType;
    private final Map<Integer, E> reverseLookupMap = new ConcurrentHashMap<Integer, E>();
    private final AtomicInteger nextUnknown;
    private final int lastUnknown;
    private final boolean bitmask;
    private Constant[] cache = null;
    private volatile E[] valueCache = null;
    private volatile int cacheGuard = 0;
    private volatile ConstantSet constants;

    private ConstantResolver(Class<E> clazz) {
        this(clazz, Integer.MIN_VALUE, -2147482648, false);
    }

    private ConstantResolver(Class<E> clazz, int n, int n2, boolean bl) {
        this.enumType = clazz;
        this.nextUnknown = new AtomicInteger(n);
        this.lastUnknown = n2;
        this.bitmask = bl;
    }

    static final <T extends Enum<T>> ConstantResolver<T> getResolver(Class<T> clazz) {
        return new ConstantResolver<T>(clazz);
    }

    static final <T extends Enum<T>> ConstantResolver<T> getResolver(Class<T> clazz, int n, int n2) {
        return new ConstantResolver<T>(clazz, n, n2, false);
    }

    static final <T extends Enum<T>> ConstantResolver<T> getBitmaskResolver(Class<T> clazz) {
        return new ConstantResolver<T>(clazz, 0, Integer.MIN_VALUE, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Constant getConstant(E e) {
        Constant constant;
        if (this.cacheGuard != 0 && (constant = this.cache[((Enum)e).ordinal()]) != null) {
            return constant;
        }
        Object object = this.modLock;
        synchronized (object) {
            if (this.cacheGuard != 0 && (constant = this.cache[((Enum)e).ordinal()]) != null) {
                return constant;
            }
            EnumSet<Enum> enumSet = EnumSet.allOf(this.enumType);
            ConstantSet constantSet = this.getConstants();
            if (this.cache == null) {
                this.cache = new Constant[enumSet.size()];
            }
            long l = 0L;
            long l2 = 0L;
            for (Enum enum_ : enumSet) {
                constant = constantSet.getConstant(enum_.name());
                if (constant == null) {
                    if (this.bitmask) {
                        l2 |= 1L << enum_.ordinal();
                        constant = new UnknownConstant(0, enum_.name());
                    } else {
                        constant = new UnknownConstant(this.nextUnknown.getAndAdd(1), enum_.name());
                    }
                } else if (this.bitmask) {
                    l |= (long)constant.value();
                }
                this.cache[enum_.ordinal()] = constant;
            }
            if (this.bitmask) {
                long l3 = 0L;
                while ((l3 = Long.lowestOneBit(l2)) != 0L) {
                    int n = Long.numberOfTrailingZeros(l3);
                    int n2 = Long.numberOfTrailingZeros(Long.lowestOneBit(l ^ 0xFFFFFFFFFFFFFFFFL));
                    int n3 = 1 << n2;
                    this.cache[n] = new UnknownConstant(n3, this.cache[n].name());
                    l |= (long)n3;
                    l2 &= 1L << n ^ 0xFFFFFFFFFFFFFFFFL;
                }
            }
            this.cacheGuard = 1;
        }
        return this.cache[((Enum)e).ordinal()];
    }

    final int intValue(E e) {
        return this.getConstant(e).value();
    }

    final String description(E e) {
        return this.getConstant(e).toString();
    }

    final E valueOf(int n) {
        Enum enum_;
        if (n >= 0 && n < 256 && this.valueCache != null && (enum_ = this.valueCache[n]) != null) {
            return (E)enum_;
        }
        enum_ = (Enum)this.reverseLookupMap.get(n);
        if (enum_ != null) {
            return (E)enum_;
        }
        Constant constant = this.getConstants().getConstant(n);
        if (constant != null) {
            try {
                enum_ = Enum.valueOf(this.enumType, constant.name());
                this.reverseLookupMap.put(n, enum_);
                if (constant.value() >= 0 && constant.value() < 256) {
                    Object[] objectArray = this.valueCache;
                    if (objectArray == null) {
                        objectArray = (Enum[])Array.newInstance(this.enumType, 256);
                    }
                    objectArray[constant.value()] = enum_;
                    this.valueCache = objectArray;
                }
                return (E)enum_;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return Enum.valueOf(this.enumType, __UNKNOWN_CONSTANT__);
    }

    private final ConstantSet getConstants() {
        if (this.constants == null) {
            this.constants = ConstantSet.getConstantSet(this.enumType.getSimpleName());
            if (this.constants == null) {
                throw new RuntimeException("Could not load platform constants for " + this.enumType.getSimpleName());
            }
        }
        return this.constants;
    }

    private static final class UnknownConstant
    implements Constant {
        private final int value;
        private final String name;

        UnknownConstant(int n, String string) {
            this.value = n;
            this.name = string;
        }

        public int value() {
            return this.value;
        }

        public String name() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

